package cz.drg.clasificator.args;

import cz.drg.clasificator.readers.InputReader;
import cz.drg.clasificator.writers.OutputWriter;

/**
 * Core part of the program controlling the flow of execution of PMML evaluation.
 * 
 * @author Pavel Jirasek
 */
public interface ProgramExecutor {
    
    /**
     * Sets the writer to use after classification of the input data based on provided PMML.
     * 
     * @param writer 
     */
    public void setWriter(OutputWriter writer);
    /**
     * Sets the reader to use to fetch input data to the classificator. 
     * 
     * @param reader 
     */
    public void setReader(InputReader reader);
    
    /**
     * Calling this will stop execution of the program. It could be either by exception,
     * System.exit or any other means to stop it.
     * 
     * @param message
     * @throws Exception 
     */
    public void stopExecution(String message);
    
    /**
     * Starts the execution of the program. The program execution should include
     * evaluation of the input arguments based on the program settings, classification
     * of the input data based on provided PMML and writing the result somewhere.
     * How the data is read and written is determined by used InputReader and OutputWriter, which
     * should be selected based upon input arguments of the program.
     * 
     * @param args 
     */
    public void execute(String[] args);
    
}
